using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectOrder
	/// </summary>
	public class DlgSelectOrder : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		bool _selectedRow; //Used with the list of Orders
		private Guid _orderedTestGuid;
		private Guid _orderedComponentGuid;
		private int _orderableTestID;
		private Guid _patientSpecimenGuid;
		private Guid _patientTreatmentGuid; //Holds parent order patient treatment
		private ArrayList _orderedTestsList; //Holds data passed from UC_56
		private ArrayList _orderedComponentsList; //Holds data passed from UC_56
		private bool _oneParentOrder;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpMessage;
		private System.Windows.Forms.Label lblMessage;
		private System.Windows.Forms.GroupBox grpOrderGroups;
		private System.Windows.Forms.ListView lvOrders;
		private System.Windows.Forms.ColumnHeader colIcon;
		private System.Windows.Forms.ColumnHeader colUrgency;
		private System.Windows.Forms.ColumnHeader colProcedure;
		private System.Windows.Forms.ColumnHeader colProvider;
		private System.Windows.Forms.ColumnHeader colPatientLocation;
		private System.Windows.Forms.ColumnHeader colDateReceived;
		private System.Windows.Forms.ColumnHeader colDateWanted;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors\Dispose
		
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTests"></param>
		/// <param name="orderedComponents"></param>
		/// <param name="oneParentOrder"></param>
		public DlgSelectOrder(ArrayList orderedTests, ArrayList orderedComponents, ref bool oneParentOrder)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			
			PopulateOrdersList(orderedTests, orderedComponents);
			oneParentOrder = this._oneParentOrder;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectOrder));
			System.Windows.Forms.ListViewItem listViewItem1 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "",
																													 "Routine",
																													 "Type & Screen",
																													 "WELBY, MARCUS",
																													 "3-EAST",
																													 "03/15/2003",
																													 "03/15/2003"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))));
			System.Windows.Forms.ListViewItem listViewItem2 = new System.Windows.Forms.ListViewItem(new string[] {
																													 "",
																													 "Pre-Op",
																													 "DAT",
																													 "WEAVER, CARRIE",
																													 "ER",
																													 "03/18/2003",
																													 "03/18/2003"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpMessage = new System.Windows.Forms.GroupBox();
			this.lblMessage = new System.Windows.Forms.Label();
			this.grpOrderGroups = new System.Windows.Forms.GroupBox();
			this.lvOrders = new System.Windows.Forms.ListView();
			this.colIcon = new System.Windows.Forms.ColumnHeader();
			this.colUrgency = new System.Windows.Forms.ColumnHeader();
			this.colProcedure = new System.Windows.Forms.ColumnHeader();
			this.colProvider = new System.Windows.Forms.ColumnHeader();
			this.colPatientLocation = new System.Windows.Forms.ColumnHeader();
			this.colDateReceived = new System.Windows.Forms.ColumnHeader();
			this.colDateWanted = new System.Windows.Forms.ColumnHeader();
			this.grpImage.SuspendLayout();
			this.grpMessage.SuspendLayout();
			this.grpOrderGroups.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(452, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Select Physician Order";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 280);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(292, 264);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(372, 264);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 228);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpMessage
			// 
			this.grpMessage.AccessibleDescription = "The specimen is associated with more than one physician order. Select the physici" +
				"an order to which the reflex test is associated. ";
			this.grpMessage.AccessibleName = "The specimen is associated with more than one physician order. Select the physici" +
				"an order to which the reflex test is associated. ";
			this.grpMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpMessage.Controls.Add(this.lblMessage);
			this.grpMessage.Location = new System.Drawing.Point(60, 32);
			this.grpMessage.Name = "grpMessage";
			this.grpMessage.Size = new System.Drawing.Size(388, 52);
			this.grpMessage.TabIndex = 0;
			this.grpMessage.TabStop = false;
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage.Location = new System.Drawing.Point(8, 12);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(372, 32);
			this.lblMessage.TabIndex = 0;
			this.lblMessage.Text = "The specimen is associated with more than one physician order. Select the physici" +
				"an order to which the reflex test is associated. ";
			this.lblMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// grpOrderGroups
			// 
			this.grpOrderGroups.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpOrderGroups.Controls.Add(this.lvOrders);
			this.grpOrderGroups.Location = new System.Drawing.Point(60, 84);
			this.grpOrderGroups.Name = "grpOrderGroups";
			this.grpOrderGroups.Size = new System.Drawing.Size(388, 176);
			this.grpOrderGroups.TabIndex = 1;
			this.grpOrderGroups.TabStop = false;
			// 
			// lvOrders
			// 
			this.lvOrders.AccessibleDescription = "Orders";
			this.lvOrders.AccessibleName = "Orders";
			this.lvOrders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvOrders.CheckBoxes = true;
			this.lvOrders.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.colIcon,
																					   this.colUrgency,
																					   this.colProcedure,
																					   this.colProvider,
																					   this.colPatientLocation,
																					   this.colDateReceived,
																					   this.colDateWanted});
			this.lvOrders.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvOrders.FullRowSelect = true;
			this.lvOrders.HideSelection = false;
			listViewItem1.StateImageIndex = 0;
			listViewItem2.StateImageIndex = 0;
			this.lvOrders.Items.AddRange(new System.Windows.Forms.ListViewItem[] {
																					 listViewItem1,
																					 listViewItem2});
			this.lvOrders.Location = new System.Drawing.Point(8, 12);
			this.lvOrders.MultiSelect = false;
			this.lvOrders.Name = "lvOrders";
			this.lvOrders.Size = new System.Drawing.Size(372, 157);
			this.lvOrders.TabIndex = 0;
			this.lvOrders.View = System.Windows.Forms.View.Details;
			this.lvOrders.SelectedIndexChanged += new System.EventHandler(this.lvOrders_SelectedIndexChanged);
			this.lvOrders.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvOrders_ItemCheck);
			// 
			// colIcon
			// 
			this.colIcon.Text = "";
			this.colIcon.Width = 20;
			// 
			// colUrgency
			// 
			this.colUrgency.Text = "Urgency";
			this.colUrgency.Width = 55;
			// 
			// colProcedure
			// 
			this.colProcedure.Text = "Procedure";
			this.colProcedure.Width = 90;
			// 
			// colProvider
			// 
			this.colProvider.Text = "Ordered By";
			this.colProvider.Width = 105;
			// 
			// colPatientLocation
			// 
			this.colPatientLocation.Text = "Patient Location";
			this.colPatientLocation.Width = 85;
			// 
			// colDateReceived
			// 
			this.colDateReceived.Text = "Received";
			this.colDateReceived.Width = 80;
			// 
			// colDateWanted
			// 
			this.colDateWanted.Text = "Wanted";
			this.colDateWanted.Width = 80;
			// 
			// DlgSelectOrder
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(452, 296);
			this.Controls.Add(this.grpOrderGroups);
			this.Controls.Add(this.grpMessage);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Order_Reflex_Tests.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(460, 323);
			this.Name = "DlgSelectOrder";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Physician Order";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectOrder_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpMessage, 0);
			this.Controls.SetChildIndex(this.grpOrderGroups, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpMessage.ResumeLayout(false);
			this.grpOrderGroups.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods
		
		/// <summary>
		/// Populate list of all the orders that were selected in UC_56
		/// </summary>
		private void PopulateOrdersList(ArrayList orderedTests, ArrayList orderedComponents)
		{
			//Get data from  parms and set local variables
			this._orderedTestsList = orderedTests;
			this._orderedComponentsList = orderedComponents;

			//clear exisiting list
			this.lvOrders.Items.Clear();

			if (this._orderedTestsList.Count == 0 && this._orderedComponentsList.Count == 0)
			{
				ListViewItem lvItem = new ListViewItem("No records found");
				this.lvOrders.Items.Add(lvItem);
				this.lvOrders.CheckBoxes = false;
			}
			else
			{
				this.lvOrders.CheckBoxes = true;

				if(this._orderedTestsList.Count > 0)
				{
					foreach(BOL.OrderedTest test in this._orderedTestsList)
					{
						ListViewItem lvItem = new ListViewItem();

						if (test.OrderUrgencyText != null)
							lvItem.SubItems.Add(test.OrderUrgencyText.ToString().Trim() + " ");
						else
							lvItem.SubItems.Add(" ");
						if (test.OrderableTest != null)
							lvItem.SubItems.Add(test.OrderableTest.ToString().Trim() + " ");
						else
							lvItem.SubItems.Add(" ");
						if (test.OrderingProviderLastName != null)
							lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(test.OrderingProviderFirstName.ToString().Trim(),
								test.OrderingProviderMiddleInitial.ToString().Trim(),
								test.OrderingProviderLastName.ToString().Trim()) + " ");
						else
							lvItem.SubItems.Add(" ");
							lvItem.SubItems.Add(" ");

						lvItem.SubItems.Add(test.OrderReceivedDateTime.ToString().Trim() + " ");
						lvItem.SubItems.Add(test.RequiredResultsDate.ToString().Trim() + " ");
						
						lvItem.Tag = test;
						this.lvOrders.Items.Add(lvItem);
					}
				}

				if(this._orderedComponentsList.Count > 0)
				{
					foreach(BOL.OrderedComponent component in this._orderedComponentsList)
					{
						ListViewItem lvItem = new ListViewItem();

						if (component.OrderUrgencyText != null)
							lvItem.SubItems.Add(component.OrderUrgencyText.ToString().Trim() + " ");
						else
							lvItem.SubItems.Add(" ");
						if (component.ComponentOrdered.BloodComponentName != null)
							lvItem.SubItems.Add(component.ComponentOrdered.BloodComponentName.ToString().Trim() + " ");
						else
							lvItem.SubItems.Add(" ");
						if (component.OrderingProviderLastName != null)
							lvItem.SubItems.Add(BOL.Patient.BuildDisplayName(component.OrderingProviderFirstName.ToString(),
								component.OrderingProviderMiddleInitial.ToString(),
								component.OrderingProviderLastName.ToString()).ToString().Trim() + " ");
						else
							lvItem.SubItems.Add(" ");
							lvItem.SubItems.Add(" ");

						lvItem.SubItems.Add(component.OrderReceivedDateTime.ToString().Trim() + " ");
						lvItem.SubItems.Add(component.RequiredDateTime.ToString().Trim() + " ");
						
						lvItem.Tag = component;
						this.lvOrders.Items.Add(lvItem);
					}
				}

				if (this._orderedTestsList.Count == 1 && this._orderedComponentsList.Count == 0)
				{
					//Only one parent order test exists
					this._oneParentOrder = true;
					ProcessSelectOrder(this.lvOrders.Items[0]);
				}
				else if (this._orderedTestsList.Count == 0 && this._orderedComponentsList.Count == 1)
				{
					//Only one parent order component exists 
					this._oneParentOrder = true;
					ProcessSelectOrder(this.lvOrders.Items[0]);
				}
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvOrders);
		}
	
		/// <summary>
		/// Sets the properties of the form based on the values of the selected order
		/// Sets the dialog box return value to OK
		/// </summary>
		private void ProcessSelectOrder(ListViewItem lvItem)
		{
			//set the property of the Ordered Test GUID or Ordered Component GUID, Orderable Test ID and Patient Specimen GUID
			

			if (lvItem.Tag.GetType().Name == "OrderedTest")
			{
				BOL.OrderedTest orderedTest = (BOL.OrderedTest) lvItem.Tag;
				this._orderedTestGuid = orderedTest.OrderedTestGuid;
				this._orderableTestID = orderedTest.OrderableTestId;
				this._patientSpecimenGuid = orderedTest.Specimen.SpecimenGuid;
				this._patientTreatmentGuid = orderedTest.PatientTreatmentGuid;
			}
			else 
			{
				BOL.OrderedComponent orderedComponent = (BOL.OrderedComponent) lvItem.Tag;
				this._orderedComponentGuid = orderedComponent.OrderedComponentGuid;
				this._orderableTestID = (int) Common.OrderableTest.XM;
				this._patientSpecimenGuid = orderedComponent.GetSpecimen().SpecimenGuid;  // CR3114
				this._patientTreatmentGuid = orderedComponent.PatientTreatmentGuid;
			}

			this.DialogResult = DialogResult.OK;
		}

		#endregion

		#region Events

		/// <summary>
		/// Occures when SelectedIndex property of Orders Listview changes
		/// </summary>
		private void lvOrders_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvOrders.CheckedItems.Count > 0)
			{
				foreach(ListViewItem lvi in this.lvOrders.CheckedItems)
				{
					lvi.Checked = false;
				}
			}

			foreach(ListViewItem lvi in ((ListView)sender).SelectedItems)
			{
				_selectedRow = true;
				lvi.Checked = true;
			}

			//Disable or enable the OK button
			if (this.lvOrders.CheckedItems.Count != 0)
			{
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.EnabledButton = false ;
			}	
			this.SpeakListViewWithCheckBox(lvOrders);
		}

		private void lvOrders_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == CheckState.Checked)
			{
				if (this.lvOrders.CheckedItems.Count > 0)
				{
					foreach(ListViewItem lvi in this.lvOrders.CheckedItems)
					{
						lvi.Checked = false;
					}
				}
				if (_selectedRow == false)
				{
					this.lvOrders.Items[e.Index].Selected = true;
				}
				else
				{
					_selectedRow = false;
				}
			}
			else
			{
				this.lvOrders.Items[e.Index].Selected = false;
			}

			//Disable or enable the OK button
			if (this.lvOrders.CheckedItems.Count != 0)
			{
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.EnabledButton = false ;
			}		
		}

		/// <summary>
		/// Sets the dialog box return value to OK
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			ProcessSelectOrder(this.lvOrders.SelectedItems[0]);
		}

		/// <summary>
		/// Sets the dialog box return value to Cancel
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectOrder_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.lblMessage.Text;
			}

			this.SpeakMessage( textToSpeak );		
		}

		#endregion


		#region Properties

		/// <summary>
		/// Get/Set OrderedTestGuid
		/// </summary>
		public Guid OrderedTestGuid 
		{
			get
			{
				return this._orderedTestGuid;
			}

			set
			{
				this._orderedTestGuid = value;
			}
		}

		/// <summary>
		/// Get/Set OrderedComponentGuid
		/// </summary>
		public Guid OrderedComponentGuid
		{
			get
			{
				return this._orderedComponentGuid;
			}

			set
			{
				this._orderedComponentGuid = value;
			}
		}

		/// <summary>
		/// Get/Set OrderableTestId
		/// </summary>
		public int OrderableTestId
		{
			get
			{
				return this._orderableTestID;
			}

			set
			{
				this._orderableTestID = value;
			}
		}

		/// <summary>
		/// Get/Set PatientSpecimenGuid
		/// </summary>
		public Guid PatientSpecimenGuid
		{
			get
			{
				return this._patientSpecimenGuid;
			}

			set
			{
				this._patientSpecimenGuid = value;
			}
		}

		/// <summary>
		/// Get/Set PatientTreatmentGuid
		/// </summary>
		public Guid PatientTreatmentGuid
		{
			get
			{
				return this._patientTreatmentGuid;
			}

			set
			{
				this._patientTreatmentGuid = value;
			}
		}

		#endregion
	}
}

